IF NOT EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLES
			 WHERE TABLE_NAME='CG_FND_VERBA_NOTA_CREDITO_GRUPO_USO_EST_ARV_MERC_CATEGORIA')
begin
CREATE TABLE [dbo].[CG_FND_VERBA_NOTA_CREDITO_GRUPO_USO_EST_ARV_MERC_CATEGORIA](
	[CD_CTR_GRUPO] [int] NOT NULL,
	[CD_EMP] [int] NOT NULL,
	[CD_ARV_MERC_CATEG] [int] NOT NULL,
	[CD_USU] [int] NOT NULL,
	[DT_CAD] [datetime] NOT NULL,
	[QT_IT] [money] NOT NULL,
	[PERC_DESC] [money] NOT NULL,
	[VLR_IT] [money] NOT NULL,
 CONSTRAINT [PK_CG_FND_VERBA_NOTA_CREDITO_GRUPO_USO_EST_ARV_MERC_CATEGORIA] PRIMARY KEY CLUSTERED 
(
	[CD_CTR_GRUPO] ASC,
	[CD_EMP] ASC,
	[CD_ARV_MERC_CATEG] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[CG_FND_VERBA_NOTA_CREDITO_GRUPO_USO_EST_ARV_MERC_CATEGORIA] ADD  CONSTRAINT [DF_CG_FND_VERBA_NOTA_CREDITO_GRUPO_USO_EST_ARV_MERC_CATEGORIA_CD_USU]  DEFAULT ((0)) FOR [CD_USU]

ALTER TABLE [dbo].[CG_FND_VERBA_NOTA_CREDITO_GRUPO_USO_EST_ARV_MERC_CATEGORIA] ADD  CONSTRAINT [DF_CG_FND_VERBA_NOTA_CREDITO_GRUPO_USO_EST_ARV_MERC_CATEGORIA_QT_IT]  DEFAULT ((0)) FOR [QT_IT]

ALTER TABLE [dbo].[CG_FND_VERBA_NOTA_CREDITO_GRUPO_USO_EST_ARV_MERC_CATEGORIA] ADD  CONSTRAINT [DF_CG_FND_VERBA_NOTA_CREDITO_GRUPO_USO_EST_ARV_MERC_CATEGORIA_PERC_DESC]  DEFAULT ((0)) FOR [PERC_DESC]

ALTER TABLE [dbo].[CG_FND_VERBA_NOTA_CREDITO_GRUPO_USO_EST_ARV_MERC_CATEGORIA] ADD  CONSTRAINT [DF_CG_FND_VERBA_NOTA_CREDITO_GRUPO_USO_EST_ARV_MERC_CATEGORIA_VLR_IT]  DEFAULT ((0)) FOR [VLR_IT]

ALTER TABLE [dbo].[CG_FND_VERBA_NOTA_CREDITO_GRUPO_USO_EST_ARV_MERC_CATEGORIA]  WITH CHECK ADD  CONSTRAINT [FK_CG_FND_VERBA_NOTA_CREDITO_GRUPO_USO_EST_ARV_MERC_CATEGORIA_CG_FND_VERBA_NOTA_CREDITO_GRUPO] FOREIGN KEY([CD_CTR_GRUPO])
REFERENCES [dbo].[CG_FND_VERBA_NOTA_CREDITO_GRUPO] ([CD_CTR_GRUPO])

ALTER TABLE [dbo].[CG_FND_VERBA_NOTA_CREDITO_GRUPO_USO_EST_ARV_MERC_CATEGORIA] CHECK CONSTRAINT [FK_CG_FND_VERBA_NOTA_CREDITO_GRUPO_USO_EST_ARV_MERC_CATEGORIA_CG_FND_VERBA_NOTA_CREDITO_GRUPO]

ALTER TABLE [dbo].[CG_FND_VERBA_NOTA_CREDITO_GRUPO_USO_EST_ARV_MERC_CATEGORIA]  WITH CHECK ADD  CONSTRAINT [FK_CG_FND_VERBA_NOTA_CREDITO_GRUPO_USO_EST_ARV_MERC_CATEGORIA_EST_ARV_MERC_CATEGORIA] FOREIGN KEY([CD_EMP], [CD_ARV_MERC_CATEG])
REFERENCES [dbo].[EST_ARV_MERC_CATEGORIA] ([CD_EMP], [CD_ARV_MERC_CATEG])

ALTER TABLE [dbo].[CG_FND_VERBA_NOTA_CREDITO_GRUPO_USO_EST_ARV_MERC_CATEGORIA] CHECK CONSTRAINT [FK_CG_FND_VERBA_NOTA_CREDITO_GRUPO_USO_EST_ARV_MERC_CATEGORIA_EST_ARV_MERC_CATEGORIA]
END